<?php
/**
 * OpenMage
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available at https://opensource.org/license/osl-3-0-php
 *
 * @category   Mage
 * @package    Mage_Sales
 * @copyright  Copyright (c) 2006-2020 Magento, Inc. (https://www.magento.com)
 * @copyright  Copyright (c) 2020-2023 The OpenMage Contributors (https://www.openmage.org)
 * @license    https://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

/**
 * @category   Mage
 * @package    Mage_Sales
 */
class Mage_Sales_Model_Email_Template extends Mage_Core_Model_Email_Template
{
    /**
     * @param string $template
     * @param array $variables
     * @return false|string
     */
    public function getInclude($template, array $variables)
    {
        $filename = Mage::getDesign()->getTemplateFilename($template);
        if (!$filename) {
            return '';
        }
        extract($variables, EXTR_SKIP);
        ob_start();
        include $filename;
        return ob_get_clean();
    }
}
